#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_SpecimenTest : BaseTest 
	{

		private BOL.SpecimenTest _tstSpecimen;
		private DataTable _dtSpecimenTest;
		private DataTable _dtOrderedTest;
		private DataTable _dtPatient;
		
		
		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//**Get SpecimenTest data
				this._dtSpecimenTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM SpecimenTest WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				//***Get OrderedTest data
				this._dtOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedTest WHERE PatientSpecimenGuid IS NOT NULL AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				//***Get Patient data
				this._dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Patient", true);

				this.RefreshData = false;
			}

			_tstSpecimen = new BOL.SpecimenTest(this._dtSpecimenTest.Rows[0]);
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.SpecimenTest tmpST = new BOL.SpecimenTest();

			Assert.IsNotNull(tmpST);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.SpecimenTest tmpST = new BOL.SpecimenTest(this._dtSpecimenTest.Rows[0]);

			Assert.IsNotNull(tmpST);
			Assert.IsTrue(tmpST.SpecimenTestGuid == this._tstSpecimen.SpecimenTestGuid);
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void Ctor_DataRow_Fail()
		{
			BOL.SpecimenTest tmpST = new BOL.SpecimenTest(null);
		}

		[Test]
		public void SpecimenTestGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstSpecimen.SpecimenTestGuid = tstValue;

			Assert.IsTrue(this._tstSpecimen.SpecimenTestGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenTestGuid_Fail()
		{
		}

		[Test]
		public void DivisionCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSpecimen.DivisionCode = tstValue;

			Assert.IsTrue(this._tstSpecimen.DivisionCode == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionCode_Fail()
		{
		}

		[Test]
		public void OrderedTest_Pass()
		{
			BOL.OrderedTest tstValue = new BOL.OrderedTest(this._dtOrderedTest.Rows[0]);

			this._tstSpecimen.OrderedTest = tstValue;

			Assert.IsTrue(this._tstSpecimen.OrderedTest == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderedTest_Fail()
		{
		}

		[Test]
		public void TestingMethod_Pass()
		{
			BOL.TestingMethod tstValue = new BOL.TestingMethod("A");

			this._tstSpecimen.TestingMethod = tstValue;

			Assert.IsTrue(this._tstSpecimen.TestingMethod == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestingMethod_Fail()
		{
		}

		[Test]
		public void Rack_Pass()
		{
			BOL.Rack tstValue = new BOL.Rack();

			this._tstSpecimen.Rack = tstValue;

			Assert.IsTrue(this._tstSpecimen.Rack == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Rack_Fail()
		{
		}

		[Test]
		public void BloodTestType_Pass()
		{
			BOL.BloodTestType tstValue = new BOL.BloodTestType(1);

			this._tstSpecimen.BloodTestType = tstValue;

			Assert.IsTrue(this._tstSpecimen.BloodTestType == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodTestType_Fail()
		{
		}

		[Test]
		public void TestResult_Pass()
		{
			BOL.TestResult tstValue = new BOL.TestResult();

			this._tstSpecimen.TestResult = tstValue;

			Assert.IsTrue(this._tstSpecimen.TestResult == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestResult_Fail()
		{
		}

		[Test]
		public void AntibodyType_Pass()
		{
			BOL.AntibodyType tstValue = new BOL.AntibodyType();

			this._tstSpecimen.AntibodyType = tstValue;

			Assert.IsTrue(this._tstSpecimen.AntibodyType == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AntibodyType_Fail()
		{
		}

		[Test]
		public void TestComments_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSpecimen.TestComments = tstValue;

			Assert.IsTrue(this._tstSpecimen.TestComments == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestComments_Fail()
		{
		}

		[Test]
		public void AutoInstrumentName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSpecimen.AutoInstrumentName = tstValue;

			Assert.IsTrue(this._tstSpecimen.AutoInstrumentName == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AutoInstrumentName_Fail()
		{
		}

		[Test]
		public void TestDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstSpecimen.TestDate = tstValue;

			Assert.IsTrue(this._tstSpecimen.TestDate == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestDate_Fail()
		{
		}

		[Test]
		public void TestTechId_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSpecimen.TestTechId = tstValue;

			Assert.IsTrue(this._tstSpecimen.TestTechId == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestTechId_Fail()
		{
		}

		[Test]
		public void AboRHChangeIndicator_Pass()
		{
			bool tstValue = (!this._tstSpecimen.AboRHChangeIndicator);

			this._tstSpecimen.AboRHChangeIndicator = tstValue;

			Assert.IsTrue(this._tstSpecimen.AboRHChangeIndicator == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AboRHChangeIndicator_Fail()
		{
		}

		[Test]
		public void InitializeSpecimenTestTable_False_Pass()
		{
			DataTable dtTest = SpecimenTest.InitializeSpecimenTestTable(false);

			Assert.IsTrue(dtTest.Columns.Count == 21);
			Assert.IsTrue(dtTest.TableName == (TABLES.SpecimenTest.TableName+"Insert"));
		}

		[Test]
		public void InitializeSpecimenTestTable_True_Pass()
		{
			DataTable dtTest = SpecimenTest.InitializeSpecimenTestTable(true);

			Assert.IsTrue(dtTest.Columns.Count == 8);
			Assert.IsTrue(dtTest.TableName == (TABLES.SpecimenTest.TableName+"Update"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InitializeSpecimenTestTable_Fail()
		{
		}

		[Test]
		public void BuildSpecimenTestRowsFromABORh_Pass()
		{
			DataTable dt = new DataTable("ABORh");

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add("AntiA", typeof(string));
			dt.Columns.Add("AntiB", typeof(string));
			dt.Columns.Add("AntiAB", typeof(string));
			dt.Columns.Add("A1Cells", typeof(string));
			dt.Columns.Add("BCells", typeof(string));
			dt.Columns.Add("AntiD", typeof(string));
			dt.Columns.Add("ControlD", typeof(string));			
			dt.Columns.Add("AboInterp", typeof(string));			
			dt.Columns.Add("RhInterp", typeof(string));			
			dt.Columns.Add(ARTIFICIAL.AboComment, typeof(string));
			dt.Columns.Add(ARTIFICIAL.RhComment, typeof(string));
			dt.Columns.Add("PatientGuid", typeof(Guid));
			dt.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dt.Columns.Add("OrderedTestGuid", typeof(Guid));
			dt.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dt.Columns.Add("InitialABO", typeof(string));
			dt.Columns.Add("InitialRh", typeof(string));
			dt.Columns.Add("SystemABO", typeof(string));
			dt.Columns.Add("SystemRh", typeof(string));
			dt.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add("AntiASave", typeof(bool));
			dt.Columns.Add("AntiBSave", typeof(bool));
			dt.Columns.Add("AntiABSave", typeof(bool));
			dt.Columns.Add("A1CellsSave", typeof(bool));
			dt.Columns.Add("BCellsSave", typeof(bool));
			dt.Columns.Add("AntiDSave", typeof(bool));
			dt.Columns.Add("ControlDSave", typeof(bool));			
			dt.Columns.Add("AboInterpSave", typeof(bool));			
			dt.Columns.Add("RhInterpSave", typeof(bool));	
			dt.Columns.Add("AntiAGuid", typeof(System.Guid));
			dt.Columns.Add("AntiBGuid", typeof(System.Guid));
			dt.Columns.Add("AntiABGuid", typeof(System.Guid));
			dt.Columns.Add("A1CellsGuid", typeof(System.Guid));
			dt.Columns.Add("BCellsGuid", typeof(System.Guid));
			dt.Columns.Add("AntiDGuid", typeof(System.Guid));
			dt.Columns.Add("ControlDGuid", typeof(System.Guid));			
			dt.Columns.Add("AboInterpGuid", typeof(System.Guid));			
			dt.Columns.Add("RhInterpGuid", typeof(System.Guid));
			dt.Columns.Add("AntiARowVersion", typeof(byte[]));
			dt.Columns.Add("AntiBRowVersion", typeof(byte[]));
			dt.Columns.Add("AntiABRowVersion", typeof(byte[]));
			dt.Columns.Add("A1CellsRowVersion", typeof(byte[]));
			dt.Columns.Add("BCellsRowVersion", typeof(byte[]));
			dt.Columns.Add("AntiDRowVersion", typeof(byte[]));
			dt.Columns.Add("ControlDRowVersion", typeof(byte[]));			
			dt.Columns.Add("AboInterpRowVersion", typeof(byte[]));			
			dt.Columns.Add("RhInterpRowVersion", typeof(byte[]));
			//dt.Columns.Add("CannedCommentID");	
			dt.Columns.Add("CannedCommentGuid");
			dt.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			dt.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));

			DataRow dr = dt.NewRow();
			dr["AntiA"] = "2";
			dr["AntiB"] = "0";
			dr["AntiAB"] = "3";
			dr["A1Cells"] = "0";
			dr["BCells"] = "4";
			dr["AntiD"] = "2";
			dr["ControlD"] = "0";
			dr["AboInterp"] = "A";
			dr["RhInterp"] = "P";

			dr["AntiASave"] = true;
			dr["AntiBSave"] = true;
			dr["AntiABSave"] = true;
			dr["A1CellsSave"] = true;
			dr["BCellsSave"] = true;
			dr["AntiDSave"] = true;
			dr["ControlDSave"] = true;
			dr["AboInterpSave"] = true;
			dr["RhInterpSave"] = true;

			dr[ARTIFICIAL.PartiallyCompleted] = true;
			dr[TABLES.OrderableTest.OrderableTestId] = "1";
			dr[TABLES.SpecimenTest.CorrectedResultIndicator] = true;
			
			dt.Rows.Add(dr);

			DataTable dtSpecimenTestInsert = BOL.SpecimenTest.InitializeSpecimenTestTable(false);
			DataTable dtSpecimenTestUpdate = BOL.SpecimenTest.InitializeSpecimenTestTable(true);
			
			SpecimenTest.BuildSpecimenTestRowsFromABORh(dt, dtSpecimenTestInsert, dtSpecimenTestUpdate, DateTime.Now, Common.LogonUser.LogonUserName, "", false);
			Assert.IsTrue(dtSpecimenTestInsert.Rows.Count + dtSpecimenTestUpdate.Rows.Count > 0);
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void BuildSpecimenTestRowsFromABORh_Fail()
		{
			SpecimenTest.BuildSpecimenTestRowsFromABORh(null, null, null, DateTime.MinValue, "", "", false);
		}
        
		[Test]
		public void BuildSpecimenTestRowsFromDAT_Pass()
		{
			DataTable dt = new DataTable("DAT");

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add("TestType", typeof(string));
			dt.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dt.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dt.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dt.Columns.Add("AHGInterp", typeof(string));
			dt.Columns.Add("AHGComment", typeof(string));
			dt.Columns.Add("PatientGuid", typeof(Guid));
			dt.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dt.Columns.Add("OrderedTestGuid", typeof(Guid));
			dt.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
			dt.Columns.Add("Manufacturer", typeof(string));
			dt.Columns.Add("ExpirationDate", typeof(DateTime));
			dt.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dt.Columns.Add("SystemAHGInterp", typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add("LotNumberSave", typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dt.Columns.Add("AHGInterpSave", typeof(bool));
			//dt.Columns.Add("CannedCommentID");
			dt.Columns.Add("CannedCommentGuid");
			dt.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGGuid, typeof(System.Guid));
			dt.Columns.Add(ARTIFICIAL.CCGuid, typeof(System.Guid));
			dt.Columns.Add("AHGInterpGuid", typeof(System.Guid));
			dt.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dt.Columns.Add("AHGInterpRowVersion", typeof(byte[]));

			dt.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));

			DataRow dr = dt.NewRow();
			dr[ARTIFICIAL.AHG] = "2";
			dr[ARTIFICIAL.CC] = "3";
			dr["AHGInterp"] = "P";

			dr[ARTIFICIAL.AHGSave] = true;
			dr[ARTIFICIAL.CCSave] = true;
			dr["AHGInterpSave"] = true;

			dr[ARTIFICIAL.PartiallyCompleted] = true;
			dr[TABLES.OrderableTest.OrderableTestId] = "4";
			dr[TABLES.SpecimenTest.CorrectedResultIndicator] = true;

			dt.Rows.Add(dr);

			DataTable dtSpecimenTestInsert = BOL.SpecimenTest.InitializeSpecimenTestTable(false);
			DataTable dtSpecimenTestUpdate = BOL.SpecimenTest.InitializeSpecimenTestTable(true);

			SpecimenTest.BuildSpecimenTestRowsFromDAT(dt, dtSpecimenTestInsert, dtSpecimenTestUpdate, DateTime.Now, "DNS   DobraK", "", false);
			Assert.IsTrue(dtSpecimenTestInsert.Rows.Count + dtSpecimenTestUpdate.Rows.Count > 0);
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void BuildSpecimenTestRowsFromDAT_Fail()
		{
			SpecimenTest.BuildSpecimenTestRowsFromDAT(null, null, null, DateTime.MinValue, "", "", false);
		}

		[Test]
		public void BuildQCDataFromDAT_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'4',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid reagentGuid = Guid.NewGuid();
			string insertReagent = "INSERT INTO REAGENT (";
			insertReagent += TABLES.Reagent.ReagentGuid + ",";
			insertReagent += TABLES.Reagent.ReagentTypeId + ",";
			insertReagent += TABLES.Reagent.ReagentName + ",";
			insertReagent += TABLES.Reagent.LotNumber + ",";
			insertReagent += TABLES.PatientSpecimen.DivisionCode + ",";
			insertReagent += TABLES.Reagent.RecordStatusCode + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertReagent += "VALUES (";
			insertReagent += "'" + reagentGuid.ToString() + "',";
			insertReagent += "'1',";
			insertReagent += "'TestReagent',";
			insertReagent += "'53000',";
			insertReagent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertReagent += "'A',";
			insertReagent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertReagent += "'UnitTestUser',";
			insertReagent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertReagent);

			DataTable dtRackLots = new DataTable();
			dtRackLots.Columns.Add("RackLotGuid", typeof(Guid));
			dtRackLots.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtRackLots.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtRackLots.Columns.Add("TestWithName");
			dtRackLots.Columns.Add(TABLES.RackLot.TestWithId, typeof(int));
			dtRackLots.Columns.Add("ExpectedMinimumReactions");
			dtRackLots.Columns.Add("SatisfactoryResultIndicator", typeof(bool));
			dtRackLots.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode);
			dtRackLots.Columns.Add("LotUseDate", typeof(DateTime));
			dtRackLots.Columns.Add(TABLES.VamcDivision.DivisionCode);
			dtRackLots.Columns.Add("LastUpdateUser");
			dtRackLots.Columns.Add("ControlCellId", typeof(bool));
			dtRackLots.Columns.Add("Comments");

			DataTable dtRackTestsInsert = new DataTable();
			dtRackTestsInsert.Columns.Add("RackTestGuid", typeof(Guid));
			dtRackTestsInsert.Columns.Add("RackLotGuid", typeof(Guid));
			dtRackTestsInsert.Columns.Add(TABLES.BloodUnitTest.TestDate);
			dtRackTestsInsert.Columns.Add("RackTestResult");
			dtRackTestsInsert.Columns.Add("RackTestResultTypeCode");
			dtRackTestsInsert.Columns.Add(TABLES.VamcDivision.DivisionCode);
			// ToDo: Not sure if this is right, but needs to pass unit test (C. Jensen, 20040728)
			dtRackTestsInsert.Columns.Add(TABLES.BloodUnitTest.TestTechId);
			dtRackTestsInsert.Columns.Add("RecordStatusCode");
			dtRackTestsInsert.Columns.Add("LastUpdateUser");

			DataTable dtRackTestsUpdate = new DataTable();
			dtRackTestsUpdate.Columns.Add("RackTestGuid", typeof(Guid));
			dtRackTestsUpdate.Columns.Add(TABLES.BloodUnitTest.TestDate);
			dtRackTestsUpdate.Columns.Add("RackTestResult");
			dtRackTestsUpdate.Columns.Add(TABLES.VamcDivision.DivisionCode);
			// ToDo: Not sure if this is right, but needs to pass unit test (C. Jensen, 20040728)
			dtRackTestsUpdate.Columns.Add(TABLES.BloodUnitTest.TestTechId);
			dtRackTestsUpdate.Columns.Add("RecordStatusCode");
			dtRackTestsUpdate.Columns.Add("RowVersion", typeof(byte[]));
			dtRackTestsUpdate.Columns.Add("LastUpdateUser");

			DataTable dtAntiseraOrderedTests = new DataTable();
			dtAntiseraOrderedTests.Columns.Add(TABLES.AntiseraOrderedTest.AntiseraOrderedTestGuid);
			dtAntiseraOrderedTests.Columns.Add(TABLES.AntiseraOrderedTest.RackLotGuid);
			dtAntiseraOrderedTests.Columns.Add(TABLES.AntiseraOrderedTest.OrderedTestGuid);
			dtAntiseraOrderedTests.Columns.Add(TABLES.AntiseraOrderedTest.LastUpdateUser);
			dtAntiseraOrderedTests.Columns.Add(TABLES.AntiseraOrderedTest.RecordStatusCode);
	
			DataTable dtOrderedTests = OrderedTest.GetTestingTaskList("");
			DataTable dtReagents = Reagent.GetReagents(UnitTestConfig.TestDivisionCode);

			DataTable dt = new DataTable("DAT");

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add("TestType", typeof(string));
			dt.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dt.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dt.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dt.Columns.Add("AHGInterp", typeof(string));
			dt.Columns.Add("AHGComment", typeof(string));
			dt.Columns.Add("PatientGuid", typeof(Guid));
			dt.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dt.Columns.Add("OrderedTestGuid", typeof(Guid));
			dt.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
			dt.Columns.Add("Manufacturer", typeof(string));
			dt.Columns.Add("ExpirationDate", typeof(DateTime));
			dt.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dt.Columns.Add("SystemAHGInterp", typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add("LotNumberSave", typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dt.Columns.Add("AHGInterpSave", typeof(bool));
			dt.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));

			dt.Columns.Add(ARTIFICIAL.AHGGuid, typeof(System.Guid));
			dt.Columns.Add(ARTIFICIAL.CCGuid, typeof(System.Guid));
			dt.Columns.Add("AHGInterpGuid", typeof(System.Guid));

			dt.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dt.Columns.Add("AHGInterpRowVersion", typeof(byte[]));

			for (int i=0; i<3; i++)
			{
				DataRow dr = dt.NewRow();
				dr[ARTIFICIAL.AHG] = "2";
				dr[ARTIFICIAL.CC] = "3";
				dr["AHGInterp"] = "P";

				dr[ARTIFICIAL.AHGSave] = true;
				dr[ARTIFICIAL.CCSave] = true;
				dr["AHGInterpSave"] = true;

				dr[ARTIFICIAL.PartiallyCompleted] = true;
				dr[TABLES.OrderableTest.OrderableTestId] = "4";
				dr["OrderedTestGuid"] = orderedTestGuid;
				dr["PatientGuid"] = patientGuid;
				dr["PatientSpecimenGuid"] = patientSpecimenGuid;
				dr[TABLES.Reagent.ReagentGuid] = reagentGuid;
				dr[TABLES.ReagentType.ReagentTypeId] = 1;
				dr[TABLES.Reagent.LotNumber] = "53000";
				dr["LotNumberSave"] = true;
			
				dt.Rows.Add(dr);
			}

			try
			{
				SpecimenTest.BuildQCDataFromDAT(dt, dtRackLots, dtRackTestsInsert, dtRackTestsUpdate, dtAntiseraOrderedTests, DateTime.Now, "TestTech");
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM REAGENT WHERE REAGENTGUID = '" + reagentGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM dbo.PatientSPECIMEN WHERE PatientSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
			}

			Assert.IsTrue(dtRackLots.Rows.Count > 0);
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void BuildQCDataFromDAT_Fail()
		{
			SpecimenTest.BuildQCDataFromDAT(null, null, null, null, null, DateTime.Now, "");
		}

		[Test]
		public void BuildSpecimenTestRowsFromAGT_Pass()
		{
			DataTable dt = new DataTable("AGC");

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add("TestType", typeof(string));
			dt.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dt.Columns.Add(ARTIFICIAL.VialId);
			dt.Columns.Add(ARTIFICIAL.IS, typeof(string));
			dt.Columns.Add(ARTIFICIAL.RT, typeof(string));
			dt.Columns.Add(ARTIFICIAL.C37, typeof(string));
			dt.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dt.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dt.Columns.Add(ARTIFICIAL.Interp, typeof(string));
			dt.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dt.Columns.Add("PatientGuid", typeof(Guid));
			dt.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dt.Columns.Add("OrderedTestGuid", typeof(Guid));
			dt.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
			dt.Columns.Add("Manufacturer", typeof(string));
			dt.Columns.Add("ExpirationDate", typeof(DateTime));
			dt.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dt.Columns.Add("SystemAHGInterp", typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add("LotNumberSave", typeof(bool));
			dt.Columns.Add("VialIDSave", typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dt.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(int));
			dt.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.RTGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));

			dt.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.RTRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.InterpRowVersion, typeof(byte[]));

			dt.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));

			DataRow dr = dt.NewRow();
			dr[ARTIFICIAL.VialId] = "1";
			dr[ARTIFICIAL.AHG] = "2";
			dr[ARTIFICIAL.CC] = "3";
			dr[ARTIFICIAL.Interp] = "P";

			dr["VialIDSave"] = true;
			dr[ARTIFICIAL.AHGSave] = true;
			dr[ARTIFICIAL.CCSave] = true;
			dr[ARTIFICIAL.InterpSave] = true;

			dr[ARTIFICIAL.PartiallyCompleted] = true;
			dr[TABLES.OrderableTest.OrderableTestId] = "4";
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = (int)Common.ReactivityPhase.AHGandCC;
			dr["TestType"] = "Patient";
			dr[TABLES.SpecimenTest.CorrectedResultIndicator] = true;

			dt.Rows.Add(dr);

			DataTable dtSpecimenTestInsert = BOL.SpecimenTest.InitializeSpecimenTestTable(false);
			DataTable dtSpecimenTestUpdate = BOL.SpecimenTest.InitializeSpecimenTestTable(true);

			SpecimenTest.BuildSpecimenTestRowsFromAGT(dt, dtSpecimenTestInsert, dtSpecimenTestUpdate, DateTime.Now, "DNS   DobraK", Common.TestingMethod.Tube, "", false);
			Assert.IsTrue(dtSpecimenTestInsert.Rows.Count + dtSpecimenTestUpdate.Rows.Count > 0);
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void BuildSpecimenTestRowsFromAGT_Fail()
		{
			SpecimenTest.BuildSpecimenTestRowsFromAGT(null, null, null, DateTime.MinValue, "", Common.TestingMethod.Unknown, "", false);
		}

		[Test]
		public void BuildQCDataFromAGT_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'12',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid reagentGuid = Guid.NewGuid();
			string insertReagent = "INSERT INTO REAGENT (";
			insertReagent += TABLES.Reagent.ReagentGuid + ",";
			insertReagent += TABLES.Reagent.ReagentTypeId + ",";
			insertReagent += TABLES.Reagent.ReagentName + ",";
			insertReagent += TABLES.Reagent.LotNumber + ",";
			insertReagent += TABLES.PatientSpecimen.DivisionCode + ",";
			insertReagent += TABLES.Reagent.RecordStatusCode + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertReagent += "VALUES (";
			insertReagent += "'" + reagentGuid.ToString() + "',";
			insertReagent += "'1',";
			insertReagent += "'TestReagent',";
			insertReagent += "'53000',";
			insertReagent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertReagent += "'A',";
			insertReagent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertReagent += "'UnitTestUser',";
			insertReagent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertReagent);

			DataTable dtRackLots = new DataTable();
			dtRackLots.Columns.Add("RackLotGuid", typeof(Guid));
			dtRackLots.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtRackLots.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtRackLots.Columns.Add("TestWithName");
			dtRackLots.Columns.Add(TABLES.RackLot.TestWithId, typeof(int));
			dtRackLots.Columns.Add("ExpectedMinimumReactions");
			dtRackLots.Columns.Add("SatisfactoryResultIndicator", typeof(bool));
			dtRackLots.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode);
			dtRackLots.Columns.Add("LotUseDate", typeof(DateTime));
			dtRackLots.Columns.Add(TABLES.VamcDivision.DivisionCode);
			dtRackLots.Columns.Add("LastUpdateUser");
			dtRackLots.Columns.Add("ControlCellId", typeof(bool));
			dtRackLots.Columns.Add("LotVialNumber");
			dtRackLots.Columns.Add("Comments");

			DataTable dtRackTestsInsert = new DataTable();
			dtRackTestsInsert.Columns.Add("RackTestGuid", typeof(Guid));
			dtRackTestsInsert.Columns.Add("RackLotGuid", typeof(Guid));
			dtRackTestsInsert.Columns.Add(TABLES.BloodUnitTest.TestDate);
			dtRackTestsInsert.Columns.Add("RackTestResult");
			dtRackTestsInsert.Columns.Add("RackTestResultTypeCode");
			dtRackTestsInsert.Columns.Add(TABLES.VamcDivision.DivisionCode);
			dtRackTestsInsert.Columns.Add("RecordStatusCode");
			dtRackTestsInsert.Columns.Add("LastUpdateUser");
			dtRackTestsInsert.Columns.Add(TABLES.BloodUnitTest.TestTechId);

			DataTable dtRackTestsUpdate = new DataTable();
			dtRackTestsUpdate.Columns.Add("RackTestGuid", typeof(Guid));
			dtRackTestsUpdate.Columns.Add(TABLES.BloodUnitTest.TestDate);
			dtRackTestsUpdate.Columns.Add("RackTestResult");
			dtRackTestsUpdate.Columns.Add(TABLES.VamcDivision.DivisionCode);
			dtRackTestsUpdate.Columns.Add("RecordStatusCode");
			dtRackTestsUpdate.Columns.Add("LastUpdateUser");
			dtRackTestsUpdate.Columns.Add(TABLES.BloodUnitTest.TestTechId);
			dtRackTestsUpdate.Columns.Add("RowVersion", typeof(byte[]));

			DataTable dtAntiseraOrderedTests = new DataTable();
			dtAntiseraOrderedTests.Columns.Add(TABLES.AntiseraOrderedTest.AntiseraOrderedTestGuid);
			dtAntiseraOrderedTests.Columns.Add(TABLES.AntiseraOrderedTest.RackLotGuid);
			dtAntiseraOrderedTests.Columns.Add(TABLES.AntiseraOrderedTest.OrderedTestGuid);
			dtAntiseraOrderedTests.Columns.Add(TABLES.AntiseraOrderedTest.LastUpdateUser);
			dtAntiseraOrderedTests.Columns.Add(TABLES.AntiseraOrderedTest.RecordStatusCode);

			DataTable dtOrderedTests = OrderedTest.GetTestingTaskList("");
			DataTable dtReagents = Reagent.GetReagents(UnitTestConfig.TestDivisionCode);

			DataTable dt = new DataTable("AGC");

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add("TestType", typeof(string));
			dt.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dt.Columns.Add(ARTIFICIAL.VialId);
			dt.Columns.Add(ARTIFICIAL.IS, typeof(string));
			dt.Columns.Add(ARTIFICIAL.RT, typeof(string));
			dt.Columns.Add(ARTIFICIAL.C37, typeof(string));
			dt.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dt.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dt.Columns.Add(ARTIFICIAL.Interp, typeof(string));
			dt.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dt.Columns.Add("PatientGuid", typeof(Guid));
			dt.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dt.Columns.Add("OrderedTestGuid", typeof(Guid));
			dt.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
			dt.Columns.Add("Manufacturer", typeof(string));
			dt.Columns.Add("ExpirationDate", typeof(DateTime));
			dt.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dt.Columns.Add("SystemAHGInterp", typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add("LotNumberSave", typeof(bool));
			dt.Columns.Add("VialIDSave", typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dt.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode,typeof(int));
			dt.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));

			dt.Columns.Add(ARTIFICIAL.ISGuid, typeof(System.Guid));
			dt.Columns.Add(ARTIFICIAL.RTGuid, typeof(System.Guid));
			dt.Columns.Add(ARTIFICIAL.C37Guid, typeof(System.Guid));
			dt.Columns.Add(ARTIFICIAL.AHGGuid, typeof(System.Guid));
			dt.Columns.Add(ARTIFICIAL.CCGuid, typeof(System.Guid));
			dt.Columns.Add(ARTIFICIAL.InterpGuid, typeof(System.Guid));

			dt.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.RTRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.InterpRowVersion, typeof(byte[]));

			for (int i=0; i<3; i++)
			{
				DataRow dr = dt.NewRow();
				dr[ARTIFICIAL.VialId] = "1";
				dr[ARTIFICIAL.AHG] = "2";
				dr[ARTIFICIAL.CC] = "3";
				dr[ARTIFICIAL.Interp] = "P";

				dr["VialIDSave"] = true;
				dr[ARTIFICIAL.AHGSave] = true;
				dr[ARTIFICIAL.CCSave] = true;
				dr[ARTIFICIAL.InterpSave] = true;

				dr[ARTIFICIAL.PartiallyCompleted] = true;
				dr[TABLES.OrderableTest.OrderableTestId] = "4";
				dr["OrderedTestGuid"] = orderedTestGuid;
				dr["PatientGuid"] = patientGuid;
				dr["PatientSpecimenGuid"] = patientSpecimenGuid;
				dr[TABLES.Reagent.ReagentGuid] = reagentGuid;
				dr[TABLES.ReagentType.ReagentTypeId] = 1;
				dr[TABLES.Reagent.LotNumber] = "53000";
				dr["LotNumberSave"] = true;
				dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = (int)Common.ReactivityPhase.AHGandCC;
			
				dt.Rows.Add(dr);
			}

			try
			{
				SpecimenTest.BuildQCDataFromAGT(dt, dtRackLots, dtRackTestsInsert, dtRackTestsUpdate, dtAntiseraOrderedTests, DateTime.Now, "TestTech");
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM REAGENT WHERE REAGENTGUID = '" + reagentGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM dbo.PatientSPECIMEN WHERE PatientSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
			}

			Assert.IsTrue(dtRackLots.Rows.Count > 0);
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void BuildQCDataFromAGT_Fail()
		{
			SpecimenTest.BuildQCDataFromAGT(null, null, null, null, null, DateTime.Now, "");
		}

		[Test]
		public void BuildABORhFromSpecimenTest_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'1',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
			insertSpecimenTest += "'18',";
			insertSpecimenTest += "'4',";
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtABORh = new DataTable("ABORh");

			dtABORh.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtABORh.Columns.Add("AntiA", typeof(string));
			dtABORh.Columns.Add("AntiB", typeof(string));
			dtABORh.Columns.Add("AntiAB", typeof(string));
			dtABORh.Columns.Add("A1Cells", typeof(string));
			dtABORh.Columns.Add("BCells", typeof(string));
			dtABORh.Columns.Add("AntiD", typeof(string));
			dtABORh.Columns.Add("ControlD", typeof(string));			
			dtABORh.Columns.Add("AboInterp", typeof(string));			
			dtABORh.Columns.Add("RhInterp", typeof(string));			
			dtABORh.Columns.Add(ARTIFICIAL.AboComment, typeof(string));
			dtABORh.Columns.Add(ARTIFICIAL.RhComment, typeof(string));
			dtABORh.Columns.Add("PatientGuid", typeof(Guid));
			dtABORh.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtABORh.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtABORh.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtABORh.Columns.Add("InitialABO", typeof(string));
			dtABORh.Columns.Add("InitialRh", typeof(string));
			dtABORh.Columns.Add("SystemABO", typeof(string));
			dtABORh.Columns.Add("SystemRh", typeof(string));
			dtABORh.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtABORh.Columns.Add("AntiASave", typeof(bool));
			dtABORh.Columns.Add("AntiBSave", typeof(bool));
			dtABORh.Columns.Add("AntiABSave", typeof(bool));
			dtABORh.Columns.Add("A1CellsSave", typeof(bool));
			dtABORh.Columns.Add("BCellsSave", typeof(bool));
			dtABORh.Columns.Add("AntiDSave", typeof(bool));
			dtABORh.Columns.Add("ControlDSave", typeof(bool));			
			dtABORh.Columns.Add("AboInterpSave", typeof(bool));			
			dtABORh.Columns.Add("RhInterpSave", typeof(bool));	
			dtABORh.Columns.Add("AntiAGuid", typeof(Guid));
			dtABORh.Columns.Add("AntiBGuid", typeof(Guid));
			dtABORh.Columns.Add("AntiABGuid", typeof(Guid));
			dtABORh.Columns.Add("A1CellsGuid", typeof(Guid));
			dtABORh.Columns.Add("BCellsGuid", typeof(Guid));
			dtABORh.Columns.Add("AntiDGuid", typeof(Guid));
			dtABORh.Columns.Add("ControlDGuid", typeof(Guid));			
			dtABORh.Columns.Add("AboInterpGuid", typeof(Guid));			
			dtABORh.Columns.Add("RhInterpGuid", typeof(Guid));	
			dtABORh.Columns.Add("AntiARowVersion", typeof(byte[]));
			dtABORh.Columns.Add("AntiBRowVersion", typeof(byte[]));
			dtABORh.Columns.Add("AntiABRowVersion", typeof(byte[]));
			dtABORh.Columns.Add("A1CellsRowVersion", typeof(byte[]));
			dtABORh.Columns.Add("BCellsRowVersion", typeof(byte[]));
			dtABORh.Columns.Add("AntiDRowVersion", typeof(byte[]));
			dtABORh.Columns.Add("ControlDRowVersion", typeof(byte[]));			
			dtABORh.Columns.Add("AboInterpRowVersion", typeof(byte[]));			
			dtABORh.Columns.Add("RhInterpRowVersion", typeof(byte[]));	
			dtABORh.Columns.Add("CannedCommentGuid", typeof(Guid));
			dtABORh.Columns.Add("CprsOrderNumber");
			dtABORh.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dtABORh.Columns.Add("AboRhInconclusiveException", typeof(ExceptionReport));
			dtABORh.Columns.Add("EmergencyIssueExceptions", typeof(System.Collections.ArrayList));
			dtABORh.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));	
			dtABORh.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtABORh.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));  

			DataRow drABORh = dtABORh.NewRow();
			drABORh["PatientGuid"] = patientGuid;
			drABORh["PatientSpecimenGuid"] = patientSpecimenGuid;
			drABORh["OrderedTestGuid"] = orderedTestGuid;
			drABORh[TABLES.OrderableTest.OrderableTestId] = 1;
			drABORh[ARTIFICIAL.Indicator] = "";
			drABORh["AntiA"] = "";
			drABORh["AntiB"] = "";
			drABORh["AntiAB"] = "";
			drABORh["A1Cells"] = "";
			drABORh["BCells"] = "";
			drABORh["AboInterp"] = "";
			drABORh["AntiD"] = "";
			drABORh["ControlD"] = "";
			drABORh["RhInterp"] = "";
			drABORh[ARTIFICIAL.AboComment] = "";
			drABORh[ARTIFICIAL.RhComment] = "";
			drABORh["AntiASave"] = true;
			drABORh["AntiBSave"] = true;
			drABORh["AntiABSave"] = true;
			drABORh["A1CellsSave"] = true;
			drABORh["BCellsSave"] = true;
			drABORh["AboInterpSave"] = true;
			drABORh["AntiDSave"] = true;
			drABORh["ControlDSave"] = true;
			drABORh["RhInterpSave"] = true;
			drABORh[ARTIFICIAL.PartiallyCompleted] = false;

			dtABORh.Rows.Add(drABORh);

			try
			{
				SpecimenTest.BuildABORhFromSpecimenTest(drABORh, orderedTestGuid, "1");
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM SPECIMENTEST WHERE SPECIMENTESTGUID = '" + specimenTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM dbo.PatientSPECIMEN WHERE PatientSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
			}

			Assert.IsTrue(drABORh["AboInterp"].ToString().Trim() == "4");
			Assert.IsTrue((bool)drABORh["AboInterpSave"] == false);
			Assert.IsTrue(((Guid)drABORh["AboInterpGuid"]).ToString() == specimenTestGuid.ToString());
		}

		[Test]
		public void BuildABORhFromSpecimenTest_Fail()
		{
			DataTable dtABORh = new DataTable("ABORh");

			dtABORh.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtABORh.Columns.Add("AntiA", typeof(string));
			dtABORh.Columns.Add("AntiB", typeof(string));
			dtABORh.Columns.Add("AntiAB", typeof(string));
			dtABORh.Columns.Add("A1Cells", typeof(string));
			dtABORh.Columns.Add("BCells", typeof(string));
			dtABORh.Columns.Add("AntiD", typeof(string));
			dtABORh.Columns.Add("ControlD", typeof(string));			
			dtABORh.Columns.Add("AboInterp", typeof(string));			
			dtABORh.Columns.Add("RhInterp", typeof(string));			
			dtABORh.Columns.Add(ARTIFICIAL.AboComment, typeof(string));
			dtABORh.Columns.Add(ARTIFICIAL.RhComment, typeof(string));
			dtABORh.Columns.Add("PatientGuid", typeof(Guid));
			dtABORh.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtABORh.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtABORh.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtABORh.Columns.Add("InitialABO", typeof(string));
			dtABORh.Columns.Add("InitialRh", typeof(string));
			dtABORh.Columns.Add("SystemABO", typeof(string));
			dtABORh.Columns.Add("SystemRh", typeof(string));
			dtABORh.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtABORh.Columns.Add("AntiASave", typeof(bool));
			dtABORh.Columns.Add("AntiBSave", typeof(bool));
			dtABORh.Columns.Add("AntiABSave", typeof(bool));
			dtABORh.Columns.Add("A1CellsSave", typeof(bool));
			dtABORh.Columns.Add("BCellsSave", typeof(bool));
			dtABORh.Columns.Add("AntiDSave", typeof(bool));
			dtABORh.Columns.Add("ControlDSave", typeof(bool));			
			dtABORh.Columns.Add("AboInterpSave", typeof(bool));			
			dtABORh.Columns.Add("RhInterpSave", typeof(bool));	
			dtABORh.Columns.Add("AntiAGuid", typeof(Guid));
			dtABORh.Columns.Add("AntiBGuid", typeof(Guid));
			dtABORh.Columns.Add("AntiABGuid", typeof(Guid));
			dtABORh.Columns.Add("A1CellsGuid", typeof(Guid));
			dtABORh.Columns.Add("BCellsGuid", typeof(Guid));
			dtABORh.Columns.Add("AntiDGuid", typeof(Guid));
			dtABORh.Columns.Add("ControlDGuid", typeof(Guid));			
			dtABORh.Columns.Add("AboInterpGuid", typeof(Guid));			
			dtABORh.Columns.Add("RhInterpGuid", typeof(Guid));	
			dtABORh.Columns.Add("AntiARowVersion", typeof(byte[]));
			dtABORh.Columns.Add("AntiBRowVersion", typeof(byte[]));
			dtABORh.Columns.Add("AntiABRowVersion", typeof(byte[]));
			dtABORh.Columns.Add("A1CellsRowVersion", typeof(byte[]));
			dtABORh.Columns.Add("BCellsRowVersion", typeof(byte[]));
			dtABORh.Columns.Add("AntiDRowVersion", typeof(byte[]));
			dtABORh.Columns.Add("ControlDRowVersion", typeof(byte[]));			
			dtABORh.Columns.Add("AboInterpRowVersion", typeof(byte[]));			
			dtABORh.Columns.Add("RhInterpRowVersion", typeof(byte[]));	
			dtABORh.Columns.Add("CannedCommentGuid", typeof(Guid));
			dtABORh.Columns.Add("CprsOrderNumber");
			dtABORh.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dtABORh.Columns.Add("AboRhInconclusiveException", typeof(ExceptionReport));
			dtABORh.Columns.Add("EmergencyIssueExceptions", typeof(System.Collections.ArrayList));
			dtABORh.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));	
			dtABORh.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtABORh.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));  

			DataRow drABORh = dtABORh.NewRow();
			drABORh["PatientGuid"] = Guid.Empty;
			drABORh["PatientSpecimenGuid"] = Guid.Empty;
			drABORh["OrderedTestGuid"] = Guid.Empty;
			drABORh[TABLES.OrderableTest.OrderableTestId] = 1;
			drABORh[ARTIFICIAL.Indicator] = "";
			drABORh["AntiA"] = "";
			drABORh["AntiB"] = "";
			drABORh["AntiAB"] = "";
			drABORh["A1Cells"] = "";
			drABORh["BCells"] = "";
			drABORh["AboInterp"] = "";
			drABORh["AntiD"] = "";
			drABORh["ControlD"] = "";
			drABORh["RhInterp"] = "";
			drABORh[ARTIFICIAL.AboComment] = "";
			drABORh[ARTIFICIAL.RhComment] = "";
			drABORh["AntiASave"] = true;
			drABORh["AntiBSave"] = true;
			drABORh["AntiABSave"] = true;
			drABORh["A1CellsSave"] = true;
			drABORh["BCellsSave"] = true;
			drABORh["AboInterpSave"] = true;
			drABORh["AntiDSave"] = true;
			drABORh["ControlDSave"] = true;
			drABORh["RhInterpSave"] = true;
			drABORh[ARTIFICIAL.PartiallyCompleted] = false;

			dtABORh.Rows.Add(drABORh);

			SpecimenTest.BuildABORhFromSpecimenTest(drABORh, Guid.Empty, "1");

			Assert.IsTrue(drABORh["AntiA"].ToString().Trim() == "");
			Assert.IsTrue((bool)drABORh["AntiASave"] == true);
		}

		[Test]
		public void BuildDATFromSpecimenTest_Pass()
		{			
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'4',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
			insertSpecimenTest += "'53',";
			insertSpecimenTest += "'3',";
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtDAT = new DataTable("DAT");

			dtDAT.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtDAT.Columns.Add("TestType", typeof(string));
			dtDAT.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtDAT.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dtDAT.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtDAT.Columns.Add("AHGInterp", typeof(string));
			dtDAT.Columns.Add("AHGComment", typeof(string));
			dtDAT.Columns.Add("PatientGuid", typeof(Guid));
			dtDAT.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtDAT.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtDAT.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtDAT.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
			dtDAT.Columns.Add("Manufacturer", typeof(string));
			dtDAT.Columns.Add("ExpirationDate", typeof(DateTime));
			dtDAT.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtDAT.Columns.Add("SystemAHGInterp", typeof(string));
			dtDAT.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtDAT.Columns.Add("LotNumberSave", typeof(bool));
			dtDAT.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtDAT.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtDAT.Columns.Add("AHGInterpSave", typeof(bool));
			dtDAT.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtDAT.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtDAT.Columns.Add("AHGInterpGuid", typeof(Guid));
			dtDAT.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtDAT.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtDAT.Columns.Add("AHGInterpRowVersion", typeof(byte[]));
			dtDAT.Columns.Add("CprsOrderNumber");
			dtDAT.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dtDAT.Columns.Add("ReagentExpiredException", typeof(BOL.ExceptionReport));
			dtDAT.Columns.Add("EmergencyIssueExceptions", typeof(System.Collections.ArrayList));
			dtDAT.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			dtDAT.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtDAT.Columns.Add(ARTIFICIAL.IndicatorMessage);

			DataRow drDAT = dtDAT.NewRow();
			drDAT["PatientGuid"] = patientGuid;
			drDAT["PatientSpecimenGuid"] = patientSpecimenGuid;
			drDAT["OrderedTestGuid"] = orderedTestGuid;
			drDAT[TABLES.OrderableTest.OrderableTestId] = 4;
			drDAT[ARTIFICIAL.Indicator] = "";
			drDAT["TestType"] = "Patient";
			drDAT[TABLES.Reagent.LotNumber] = "";
			drDAT[ARTIFICIAL.AHG] = "";
			drDAT[ARTIFICIAL.CC] = "";
			drDAT["AHGInterp"] = "";
			drDAT["AHGComment"] = "";
			drDAT["LotNumberSave"] = true;
			drDAT[ARTIFICIAL.AHGSave] = true;
			drDAT[ARTIFICIAL.CCSave] = true;
			drDAT["AHGInterpSave"] = true;
			drDAT[ARTIFICIAL.PartiallyCompleted] = false;
			drDAT[TABLES.ReagentType.ReagentTypeId] = (int)Common.DATTestControls.PSDAT;

			dtDAT.Rows.Add(drDAT);

			try
			{
				SpecimenTest.BuildDATFromSpecimenTest(dtDAT, orderedTestGuid, "4");
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{			
				UnitTestUtil.RunSQL("DELETE FROM SPECIMENTEST WHERE SPECIMENTESTGUID = '" + specimenTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM dbo.PatientSPECIMEN WHERE PatientSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
			}

			Assert.IsTrue(dtDAT.Rows[0][ARTIFICIAL.AHG].ToString().Trim() == "3");
			Assert.IsTrue((bool)dtDAT.Rows[0][ARTIFICIAL.AHGSave] == false);
			Assert.IsTrue(((Guid)dtDAT.Rows[0][ARTIFICIAL.AHGGuid]).ToString() == specimenTestGuid.ToString());
		}

		[Test]
		public void BuildDATFromSpecimenTest_Fail()
		{
			DataTable dtDAT = new DataTable("DAT");

			dtDAT.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtDAT.Columns.Add("TestType", typeof(string));
			dtDAT.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtDAT.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dtDAT.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtDAT.Columns.Add("AHGInterp", typeof(string));
			dtDAT.Columns.Add("AHGComment", typeof(string));
			dtDAT.Columns.Add("PatientGuid", typeof(Guid));
			dtDAT.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtDAT.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtDAT.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtDAT.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
			dtDAT.Columns.Add("Manufacturer", typeof(string));
			dtDAT.Columns.Add("ExpirationDate", typeof(DateTime));
			dtDAT.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtDAT.Columns.Add("SystemAHGInterp", typeof(string));
			dtDAT.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtDAT.Columns.Add("LotNumberSave", typeof(bool));
			dtDAT.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtDAT.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtDAT.Columns.Add("AHGInterpSave", typeof(bool));
			dtDAT.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtDAT.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtDAT.Columns.Add("AHGInterpGuid", typeof(Guid));
			dtDAT.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtDAT.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtDAT.Columns.Add("AHGInterpRowVersion", typeof(byte[]));
			dtDAT.Columns.Add("CprsOrderNumber");
			dtDAT.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dtDAT.Columns.Add("ReagentExpiredException", typeof(BOL.ExceptionReport));
			dtDAT.Columns.Add("EmergencyIssueExceptions", typeof(System.Collections.ArrayList));
			dtDAT.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			dtDAT.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtDAT.Columns.Add(ARTIFICIAL.IndicatorMessage);

			DataRow drDAT = dtDAT.NewRow();
			drDAT["PatientGuid"] = Guid.Empty;
			drDAT["PatientSpecimenGuid"] = Guid.Empty;
			drDAT["OrderedTestGuid"] = Guid.Empty;
			drDAT[TABLES.OrderableTest.OrderableTestId] = 4;
			drDAT[ARTIFICIAL.Indicator] = "";
			drDAT["TestType"] = "Patient";
			drDAT[TABLES.Reagent.LotNumber] = "";
			drDAT[ARTIFICIAL.AHG] = "";
			drDAT[ARTIFICIAL.CC] = "";
			drDAT["AHGInterp"] = "";
			drDAT["AHGComment"] = "";
			drDAT["LotNumberSave"] = true;
			drDAT[ARTIFICIAL.AHGSave] = true;
			drDAT[ARTIFICIAL.CCSave] = true;
			drDAT["AHGInterpSave"] = true;
			drDAT[ARTIFICIAL.PartiallyCompleted] = false;
			drDAT[TABLES.ReagentType.ReagentTypeId] = (int)Common.DATTestControls.PSDAT;

			dtDAT.Rows.Add(drDAT);

			SpecimenTest.BuildDATFromSpecimenTest(dtDAT, Guid.Empty, "4");
			
			Assert.IsTrue(dtDAT.Rows[0][ARTIFICIAL.AHG].ToString().Trim() == "");
			Assert.IsTrue((bool)dtDAT.Rows[0][ARTIFICIAL.AHGSave] == true);
		}

		[Test]
		public void BuildAGTFromSpecimenTest_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedTest += "'12',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
			insertSpecimenTest += "'207',";
			insertSpecimenTest += "'4',";
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtAGT = new DataTable("AGC");

			dtAGT.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtAGT.Columns.Add("TestType", typeof(string));
			dtAGT.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.VialId);
			dtAGT.Columns.Add(ARTIFICIAL.IS, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.RT, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.C37, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.Interp, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtAGT.Columns.Add("PatientGuid", typeof(Guid));
			dtAGT.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtAGT.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtAGT.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtAGT.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
			dtAGT.Columns.Add("ReagentTypeName");
			dtAGT.Columns.Add("Manufacturer", typeof(string));
			dtAGT.Columns.Add("ExpirationDate", typeof(DateTime));
			dtAGT.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtAGT.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtAGT.Columns.Add("LotNumberSave", typeof(bool));
			dtAGT.Columns.Add("VialIDSave", typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.RTGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.RTRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.InterpRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(int));
			dtAGT.Columns.Add("CprsOrderNumber");
			dtAGT.Columns.Add(ARTIFICIAL.OrderedTestRowVersion,typeof(byte[]));
			dtAGT.Columns.Add("ReagentExpiredException", typeof(BOL.ExceptionReport));
			dtAGT.Columns.Add("DiscrepantTypingException", typeof(BOL.ExceptionReport));
			dtAGT.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));	
			dtAGT.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.IndicatorMessage);

			DataRow drAGT = dtAGT.NewRow();
			drAGT["PatientGuid"] = patientGuid;
			drAGT["PatientSpecimenGuid"] = patientSpecimenGuid;
			drAGT["OrderedTestGuid"] = orderedTestGuid;
			drAGT[TABLES.OrderableTest.OrderableTestId] = 12;
			drAGT[ARTIFICIAL.Indicator] = "";
			drAGT["TestType"] = "Patient";
			drAGT[TABLES.Reagent.LotNumber] = "";
			drAGT[ARTIFICIAL.VialId] = "";
			drAGT[ARTIFICIAL.IS] = "";
			drAGT[ARTIFICIAL.RT] = "";
			drAGT[ARTIFICIAL.C37] = "";
			drAGT[ARTIFICIAL.AHG] = "";
			drAGT[ARTIFICIAL.CC] = "";
			drAGT[ARTIFICIAL.Interp] = "";
			drAGT[ARTIFICIAL.Comment] = "";
			drAGT["LotNumberSave"] = true;
			drAGT["VialIDSave"] = true;
			drAGT[ARTIFICIAL.ISSave] = true;
			drAGT[ARTIFICIAL.RTSave] = true;
			drAGT[ARTIFICIAL.C37Save] = true;
			drAGT[ARTIFICIAL.AHGSave] = true;
			drAGT[ARTIFICIAL.CCSave] = true;
			drAGT[ARTIFICIAL.InterpSave] = true;
			drAGT[ARTIFICIAL.PartiallyCompleted] = false;
			drAGT[TABLES.ReagentType.ReagentTypeId] = 6;
			drAGT[TABLES.ReactivityPhase.ReactivityPhaseCode] = (int)Common.ReactivityPhase.ISand37;
			drAGT[TABLES.SpecimenTest.CorrectedResultIndicator] = false;
			dtAGT.Rows.Add(drAGT);

			try
			{
				SpecimenTest.BuildAGTFromSpecimenTest(dtAGT, new BOL.OrderedTest(orderedTestGuid, patientOrderGuid));
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM SPECIMENTEST WHERE SPECIMENTESTGUID = '" + specimenTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM ORDEREDTEST WHERE ORDEREDTESTGUID = '" + orderedTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM dbo.PatientSPECIMEN WHERE PatientSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
			}

			Assert.IsTrue(dtAGT.Rows[0][ARTIFICIAL.IS].ToString().Trim() == "4");
			Assert.IsTrue((bool)dtAGT.Rows[0][ARTIFICIAL.ISSave] == false);
			Assert.IsTrue(((Guid)dtAGT.Rows[0][ARTIFICIAL.ISGuid]).ToString() == specimenTestGuid.ToString());
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void BuildAGTFromSpecimenTest_Fail()
		{
			DataTable dtAGT = new DataTable("AGC");

			dtAGT.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtAGT.Columns.Add("TestType", typeof(string));
			dtAGT.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.VialId);
			dtAGT.Columns.Add(ARTIFICIAL.IS, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.RT, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.C37, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.Interp, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtAGT.Columns.Add("PatientGuid", typeof(Guid));
			dtAGT.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtAGT.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtAGT.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtAGT.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
			dtAGT.Columns.Add("ReagentTypeName");
			dtAGT.Columns.Add("Manufacturer", typeof(string));
			dtAGT.Columns.Add("ExpirationDate", typeof(DateTime));
			dtAGT.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtAGT.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtAGT.Columns.Add("LotNumberSave", typeof(bool));
			dtAGT.Columns.Add("VialIDSave", typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.RTGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.RTRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.InterpRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(int));
			dtAGT.Columns.Add("CprsOrderNumber");
			dtAGT.Columns.Add(ARTIFICIAL.OrderedTestRowVersion,typeof(byte[]));
			dtAGT.Columns.Add("ReagentExpiredException", typeof(BOL.ExceptionReport));
			dtAGT.Columns.Add("DiscrepantTypingException", typeof(BOL.ExceptionReport));
			dtAGT.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));	
			dtAGT.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.IndicatorMessage);

			DataRow drAGT = dtAGT.NewRow();
			drAGT["PatientGuid"] = Guid.Empty;
			drAGT["PatientSpecimenGuid"] = Guid.Empty;
			drAGT["OrderedTestGuid"] = Guid.Empty;
			drAGT[TABLES.OrderableTest.OrderableTestId] = 12;
			drAGT[ARTIFICIAL.Indicator] = "";
			drAGT["TestType"] = "Patient";
			drAGT[TABLES.Reagent.LotNumber] = "";
			drAGT[ARTIFICIAL.VialId] = "";
			drAGT[ARTIFICIAL.IS] = "";
			drAGT[ARTIFICIAL.RT] = "";
			drAGT[ARTIFICIAL.C37] = "";
			drAGT[ARTIFICIAL.AHG] = "";
			drAGT[ARTIFICIAL.CC] = "";
			drAGT[ARTIFICIAL.Interp] = "";
			drAGT[ARTIFICIAL.Comment] = "";
			drAGT["LotNumberSave"] = true;
			drAGT["VialIDSave"] = true;
			drAGT[ARTIFICIAL.ISSave] = true;
			drAGT[ARTIFICIAL.RTSave] = true;
			drAGT[ARTIFICIAL.C37Save] = true;
			drAGT[ARTIFICIAL.AHGSave] = true;
			drAGT[ARTIFICIAL.CCSave] = true;
			drAGT[ARTIFICIAL.InterpSave] = true;
			drAGT[ARTIFICIAL.PartiallyCompleted] = false;
			drAGT[TABLES.ReagentType.ReagentTypeId] = 6;
			drAGT[TABLES.ReactivityPhase.ReactivityPhaseCode] = (int)Common.ReactivityPhase.ISand37;
			drAGT[TABLES.SpecimenTest.CorrectedResultIndicator] = false;
			dtAGT.Rows.Add(drAGT);

			SpecimenTest.BuildAGTFromSpecimenTest(dtAGT, null);
		}

		[Test]
		public void BuildSpecimenTestRowsFromABID_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedTest += "'8',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedTest);

			DataTable dtAntibodyIDs = new DataTable("ABID");
			dtAntibodyIDs.Columns.Add("AntibodyTypeId", typeof(int));
			dtAntibodyIDs.Columns.Add("AntibodyTypeName");
			dtAntibodyIDs.Columns.Add("OffsiteLocation");
			dtAntibodyIDs.Columns.Add("OffsiteCost", typeof(decimal));
			//dtAntibodyIDs.Columns.Add("CannedCommentID", typeof(int));
			dtAntibodyIDs.Columns.Add("CannedCommentGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add("TestComments");
			dtAntibodyIDs.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add("PatientGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add(TABLES.OrderableTest.OrderableTestId, typeof(int));
			dtAntibodyIDs.Columns.Add("OffsiteIndicator", typeof(bool));
			dtAntibodyIDs.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));

			DataRow drAntibodyID = dtAntibodyIDs.NewRow();
			drAntibodyID["AntibodyTypeId"] = 29;
			drAntibodyID["AntibodyTypeName"] = "Anti-K";
			drAntibodyID["OffsiteLocation"] = "Kansas";
			drAntibodyID["OffsiteCost"] = 10;
			drAntibodyID["TestComments"] = "";
			drAntibodyID[TABLES.OrderableTest.OrderableTestId] = 8;
			drAntibodyID["PatientGuid"] = patientGuid;
			drAntibodyID["PatientSpecimenGuid"] = patientSpecimenGuid;
			drAntibodyID["OrderedTestGuid"] = orderedTestGuid;
			drAntibodyID["OffsiteIndicator"] = false;
			drAntibodyID[TABLES.SpecimenTest.CorrectedResultIndicator] = true;

			DataTable dtTasks = DAL.OrderedTest.GetTestingTaskList("");
			if (dtTasks.Rows.Count > 0)
			{
				drAntibodyID["PatientGuid"] = dtTasks.Rows[0]["PatientGuid"];
				drAntibodyID["OrderedTestGuid"] = dtTasks.Rows[0]["OrderedTestGuid"];
			}

			dtAntibodyIDs.Rows.Add(drAntibodyID);

			DataTable dtSpecimenTestInsert = BOL.SpecimenTest.InitializeSpecimenTestTable(false);

			DataTable dtTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(false);
			
			try
			{
				SpecimenTest.BuildSpecimenTestRowsFromABID(dtAntibodyIDs, dtSpecimenTestInsert, dtTransfusionRequirements, DateTime.Now, "DNS   DobraK", Guid.NewGuid(), "", false);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM ORDEREDTEST WHERE ORDEREDTESTGUID = '" + orderedTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM dbo.PatientSPECIMEN WHERE PatientSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
			}

			Assert.IsTrue(dtSpecimenTestInsert.Rows.Count > 0);
		}

		[Test]
		public void BuildSpecimenTestRowsFromABID_AutoInstrAndRack_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedTest += "'8',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedTest);

			DataTable dtAntibodyIDs = new DataTable("ABID");
			dtAntibodyIDs.Columns.Add("AntibodyTypeId", typeof(int));
			dtAntibodyIDs.Columns.Add("AntibodyTypeName");
			dtAntibodyIDs.Columns.Add("OffsiteLocation");
			dtAntibodyIDs.Columns.Add("OffsiteCost", typeof(decimal));
			//dtAntibodyIDs.Columns.Add("CannedCommentID", typeof(int));
			dtAntibodyIDs.Columns.Add("CannedCommentGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add("TestComments");
			dtAntibodyIDs.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add("PatientGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add(TABLES.OrderableTest.OrderableTestId, typeof(int));
			dtAntibodyIDs.Columns.Add("OffsiteIndicator", typeof(bool));
			dtAntibodyIDs.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));

			DataRow drAntibodyID = dtAntibodyIDs.NewRow();
			drAntibodyID["AntibodyTypeId"] = 29;
			drAntibodyID["AntibodyTypeName"] = "Anti-K";
			drAntibodyID["OffsiteLocation"] = "Kansas";
			drAntibodyID["OffsiteCost"] = 10;
			drAntibodyID["TestComments"] = "";
			drAntibodyID[TABLES.OrderableTest.OrderableTestId] = 8;
			drAntibodyID["PatientGuid"] = patientGuid;
			drAntibodyID["PatientSpecimenGuid"] = patientSpecimenGuid;
			drAntibodyID["OrderedTestGuid"] = orderedTestGuid;
			drAntibodyID["OffsiteIndicator"] = true;
			drAntibodyID[TABLES.SpecimenTest.CorrectedResultIndicator] = true;

			DataTable dtTasks = DAL.OrderedTest.GetTestingTaskList("");
			if (dtTasks.Rows.Count > 0)
			{
				drAntibodyID["PatientGuid"] = dtTasks.Rows[0]["PatientGuid"];
				drAntibodyID["OrderedTestGuid"] = dtTasks.Rows[0]["OrderedTestGuid"];
			}

			dtAntibodyIDs.Rows.Add(drAntibodyID);

			DataTable dtSpecimenTestInsert = BOL.SpecimenTest.InitializeSpecimenTestTable(false);

			DataTable dtTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(false);
			
			try
			{
				SpecimenTest.BuildSpecimenTestRowsFromABID(dtAntibodyIDs, dtSpecimenTestInsert, dtTransfusionRequirements, DateTime.Now, "DNS   DobraK", Guid.Empty, "Auto Instr Name", true);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM ORDEREDTEST WHERE ORDEREDTESTGUID = '" + orderedTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM dbo.PatientSPECIMEN WHERE PatientSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
			}

			Assert.IsTrue(dtSpecimenTestInsert.Rows.Count > 0);
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void BuildSpecimenTestRowsFromABID_Fail()
		{
			SpecimenTest.BuildSpecimenTestRowsFromABID(null, null, null, DateTime.MinValue, "", Guid.Empty, "", false);
		}


		[Test]
		public void BuildSpecimenTestRowsFromABS_Pass()
		{
			DataTable dtABS = new DataTable("ABS");

			//Header information
			dtABS.Columns.Add(ARTIFICIAL.Indicator, typeof(String));
			dtABS.Columns.Add("ScreeningCells",typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.IS, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.C37, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.AHG, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.CC, typeof(String));
			dtABS.Columns.Add("ABSInterp", typeof(String));			
			dtABS.Columns.Add("ABSComment", typeof(String));
			dtABS.Columns.Add("PatientGuid", typeof(Guid));
			dtABS.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtABS.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtABS.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtABS.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtABS.Columns.Add("ABSInterpSave", typeof(bool));
			dtABS.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			
			dtABS.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtABS.Columns.Add("ABSInterpInterpGuid", typeof(Guid));

			dtABS.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtABS.Columns.Add("ABSInterpRowVersion", typeof(byte[]));
			dtABS.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));

			DataRow drABS = dtABS.NewRow();
			drABS[ARTIFICIAL.IS] = "M";
			drABS[ARTIFICIAL.C37] = "";
			drABS[ARTIFICIAL.AHG] = "";
			drABS[ARTIFICIAL.CC] = "";
			drABS["ABSComment"] = "";
			drABS["ScreeningCells"] = "Auto";
			drABS["PatientSpecimenGuid"] = Guid.NewGuid();
			drABS["OrderedTestGuid"] = Guid.NewGuid();
			drABS[TABLES.OrderableTest.OrderableTestId] = 3;
			drABS[ARTIFICIAL.ISSave] = true;
			drABS[ARTIFICIAL.C37Save] = true;
			drABS[ARTIFICIAL.AHGSave] = true;
			drABS[ARTIFICIAL.CCSave] = true;
			drABS["ABSInterpSave"] = true;
			drABS[TABLES.SpecimenTest.CorrectedResultIndicator] = true;

			dtABS.Rows.Add(drABS);

			DataTable dtSpecimenTestInsert = BOL.SpecimenTest.InitializeSpecimenTestTable(false);
			DataTable dtSpecimenTestUpdate = BOL.SpecimenTest.InitializeSpecimenTestTable(true);

			SpecimenTest.BuildSpecimenTestRowsFromABS(dtABS, dtSpecimenTestInsert, dtSpecimenTestUpdate, DateTime.Now, Common.LogonUser.LogonUserName, Common.ReactivityPhase.All, "", false);
			Assert.IsTrue(dtSpecimenTestInsert.Rows.Count + dtSpecimenTestUpdate.Rows.Count > 0);

		}

		[Test]
		[ExpectedExceptionAttribute(typeof(NullReferenceException))]
		public void BuildSpecimenTestRowsFromABS_Fail()
		{
			SpecimenTest.BuildSpecimenTestRowsFromABS(null, null, null, DateTime.MinValue, string.Empty, Common.ReactivityPhase.Unknown, "", false);
		}

		[Test]
		public void BuildABSFromSpecimenTest_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedTest += "'3',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
			insertSpecimenTest += "'32',";
			insertSpecimenTest += "'4',";
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtABS = new DataTable("ABS");

			//Header information
			dtABS.Columns.Add(ARTIFICIAL.Indicator, typeof(String));
			dtABS.Columns.Add("ScreeningCells",typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.IS, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.C37, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.AHG, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.CC, typeof(String));
			dtABS.Columns.Add("ABSInterp", typeof(String));			
			dtABS.Columns.Add("ABSComment", typeof(String));
			dtABS.Columns.Add("PatientGuid", typeof(Guid));
			dtABS.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtABS.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtABS.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtABS.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtABS.Columns.Add("ABSInterpSave", typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtABS.Columns.Add("ABSInterpGuid", typeof(Guid));			
			dtABS.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtABS.Columns.Add("ABSInterpRowVersion", typeof(byte[]));			
			dtABS.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dtABS.Columns.Add("NonStandardTestException", typeof(BOL.ExceptionReport));
			dtABS.Columns.Add("EmergencyIssueExceptions", typeof(System.Collections.ArrayList));
			dtABS.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));	
			dtABS.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));  

			for (int i = 0; i < 5; i++)
			{
				DataRow drABS = dtABS.NewRow();
				drABS[ARTIFICIAL.IS] = "";
				drABS[ARTIFICIAL.C37] = "";
				drABS[ARTIFICIAL.AHG] = "";
				drABS[ARTIFICIAL.CC] = "";
				drABS["ABSComment"] = "Test comments";
				drABS["ScreeningCells"] = "";
				drABS["PatientGuid"] = patientGuid;
				drABS["PatientSpecimenGuid"] = patientSpecimenGuid;
				drABS["OrderedTestGuid"] = orderedTestGuid;
				drABS[TABLES.OrderableTest.OrderableTestId] = 3;
				dtABS.Rows.Add(drABS);
			}

			try
			{
				BOL.SpecimenTest.BuildABSFromSpecimenTest(dtABS, new BOL.OrderedTest(orderedTestGuid, patientOrderGuid));
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM SPECIMENTEST WHERE SPECIMENTESTGUID = '" + specimenTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM ORDEREDTEST WHERE ORDEREDTESTGUID = '" + orderedTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM dbo.PatientSPECIMEN WHERE PatientSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
			}

			Assert.IsTrue(dtABS.Rows[0][ARTIFICIAL.IS].ToString().Trim() == "4");
			Assert.IsTrue((bool)dtABS.Rows[0][ARTIFICIAL.ISSave] == false);
			Assert.IsTrue(((Guid)dtABS.Rows[0][ARTIFICIAL.ISGuid]).ToString() == specimenTestGuid.ToString());
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void BuildABSFromSpecimenTest_Fail()
		{
			DataTable dtABS = new DataTable("ABS");

			//Header information
			dtABS.Columns.Add(ARTIFICIAL.Indicator, typeof(String));
			dtABS.Columns.Add("ScreeningCells",typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.IS, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.C37, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.AHG, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.CC, typeof(String));
			dtABS.Columns.Add("ABSInterp", typeof(String));			
			dtABS.Columns.Add("ABSComment", typeof(String));
			dtABS.Columns.Add("PatientGuid", typeof(Guid));
			dtABS.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtABS.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtABS.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtABS.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtABS.Columns.Add("ABSInterpSave", typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtABS.Columns.Add("ABSInterpGuid", typeof(Guid));			
			dtABS.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtABS.Columns.Add("ABSInterpRowVersion", typeof(byte[]));			
			dtABS.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dtABS.Columns.Add("NonStandardTestException", typeof(BOL.ExceptionReport));
			dtABS.Columns.Add("EmergencyIssueExceptions", typeof(System.Collections.ArrayList));
			dtABS.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));	
			dtABS.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));  

			for (int i = 0; i < 5; i++)
			{
				DataRow drABS = dtABS.NewRow();
				drABS[ARTIFICIAL.IS] = "";
				drABS[ARTIFICIAL.C37] = "";
				drABS[ARTIFICIAL.AHG] = "";
				drABS[ARTIFICIAL.CC] = "";
				drABS["ABSComment"] = "Test comments";
				drABS["ScreeningCells"] = "";
				drABS["PatientGuid"] = Guid.Empty;
				drABS["PatientSpecimenGuid"] = Guid.Empty;
				drABS["OrderedTestGuid"] = Guid.Empty;
				drABS[TABLES.OrderableTest.OrderableTestId] = 3;
				dtABS.Rows.Add(drABS);
			}

			BOL.SpecimenTest.BuildABSFromSpecimenTest(dtABS, null);
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			Assert.IsNull(this._tstSpecimen.LoadDataRowFromThis(this._dtOrderedTest.NewRow()));
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		
		[Test]
		public void InvalidateSpecimenTestResults_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient WHERE VistaPatientId > 0 AND AboRhChangeIndicator <> 1 ORDER BY LastUpdateDate DESC");
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//Set ABO/Rh Change indictaor, for 100% coverage
			UnitTestUtil.RunSQL("UPDATE Patient SET AboRhChangeIndicator = 1 WHERE PatientGuid = '" + patientGuid.ToString() + "'");
			dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM dbo.Patient WHERE PatientGuid = '" + patientGuid.ToString() + "'");
			byte[] patientRV = (byte[])dtPatient.Rows[0][TABLES.Patient.RowVersion];
			//
			//This should ensure that the patient has ABO/Rh test results
			Guid patientTreatmentGuid = Guid.NewGuid();
			Guid patientSpecimenGuid = Guid.NewGuid();
			Guid patientOrderGuid = Guid.NewGuid();
			Guid orderedTestGuid = Guid.NewGuid();
			Guid specimenTestGuid1 = Guid.NewGuid();
			Guid specimenTestGuid2 = Guid.NewGuid();
			BOL_SpecimenTest.BuildABORhFromSpecimenTests(patientGuid, patientTreatmentGuid, patientSpecimenGuid, patientOrderGuid, orderedTestGuid, specimenTestGuid1, specimenTestGuid2, "A  ", "N  ");
			//
			BOL.OrderedTest tmpOT = new BOL.OrderedTest(orderedTestGuid,patientOrderGuid);
			System.Collections.ArrayList alST = BOL.OrderedTest.GetSpecimenTestResultsForOrderedTest(orderedTestGuid);

			System.Collections.ArrayList alWorkload = new System.Collections.ArrayList();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ABOForwardReverseTypingPatient);
			alWorkload.Add(Common.WorkloadProcessID.ABOForwardReverseTypingPatient);
			alWorkload.Add(Common.WorkloadProcessID.ABOForwardReverseTypingPatient);
			//
			//Insert an AntiseraOrderedTest record so that we can inactivate it!
			DataRow drRackLot = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM dbo.RackLot");
			Guid antiseraOrderedTestGuid = Guid.NewGuid();
			string insertSql = "INSERT INTO dbo.AntiseraOrderedTest (";
			insertSql += TABLES.AntiseraOrderedTest.AntiseraOrderedTestGuid+",";
			insertSql += TABLES.AntiseraOrderedTest.LastUpdateDate+",";
			insertSql += TABLES.AntiseraOrderedTest.LastUpdateFunctionId+",";
			insertSql += TABLES.AntiseraOrderedTest.LastUpdateUser+",";
			insertSql += TABLES.AntiseraOrderedTest.OrderedTestGuid+",";
			insertSql += TABLES.AntiseraOrderedTest.RackLotGuid+",";
			insertSql += TABLES.AntiseraOrderedTest.RecordStatusCode+") VALUES (";
			insertSql += "'"+antiseraOrderedTestGuid.ToString()+"',";
			insertSql += "'"+DateTime.Now.ToString()+"',";
			insertSql += "'"+Convert.ToInt32(Common.UpdateFunction.UnitTests).ToString()+"',";
			insertSql += "'"+Environment.UserName+"',";
			insertSql += "'"+orderedTestGuid.ToString()+"',";
			insertSql += "'"+drRackLot[TABLES.RackLot.RackLotGuid].ToString()+"',";
			insertSql += "'"+Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active)+"')";
			UnitTestUtil.RunSQL(insertSql);
			//
			bool retValue = BOL.SpecimenTest.InvalidateSpecimenTestResults(alST, "UnitTest", true, Common.UpdateFunction.UnitTests, alWorkload, patientGuid, patientRV);
			//
			Assert.IsTrue(retValue);
		}

		[Test]
		public void InvalidateSpecimenTestResults_Fail()
		{
			bool retValue = BOL.SpecimenTest.InvalidateSpecimenTestResults(new System.Collections.ArrayList(), "UnitTest", false, Common.UpdateFunction.UnitTests, new System.Collections.ArrayList(), Guid.Empty, new byte[0]);
			Assert.IsTrue(retValue);
		}

		private bool _skipInvalidate = false;

		public void CreateSpecimenTestResults()
		{
			_skipInvalidate = true;
			InvalidateSpecimenTestResults_ABID_Pass();
			_skipInvalidate = false;
		}

		[Test]
		public void InvalidateSpecimenTestResults_ABID_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient WHERE VistaPatientId > 1000 ORDER BY LastUpdateDate DESC");
			Guid patientGuid = Guid.Empty;
			byte[] patientRV;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
				patientRV = (byte[])dtPatient.Rows[0][TABLES.Patient.RowVersion];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			//This should ensure that the patient has ABID test results and associated TRs
			string [] queries = new string [8];
			System.Text.StringBuilder query = new System.Text.StringBuilder();
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			query.Append("INSERT INTO dbo.PatientTreatment (");
			query.Append(TABLES.PatientTreatment.PatientTreatmentGuid).Append(",");
			query.Append(TABLES.PatientTreatment.PatientGuid).Append(",");
			query.Append(TABLES.PatientTreatment.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientTreatment.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientTreatment.LastUpdateFunctionId).Append(")");
			query.Append("VALUES(");
			query.Append("'").Append(patientTreatmentGuid.ToString()).Append("',");
			query.Append("'").Append(patientGuid.ToString()).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[0] = query.ToString();
			query.Remove(0, query.Length);
			//
			Guid patientOrderGuid = Guid.NewGuid();
			query.Append("INSERT INTO dbo.PatientOrder (");
			query.Append(TABLES.PatientOrder.PatientOrderGuid).Append(",");
			query.Append(TABLES.PatientOrder.PatientTreatmentGuid).Append(",");
			query.Append(TABLES.PatientOrder.DivisionCode).Append(",");
			query.Append(TABLES.PatientOrder.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientOrder.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientOrder.LastUpdateFunctionId).Append(")");
			query.Append("VALUES(");
			query.Append("'").Append(patientOrderGuid.ToString()).Append("',");
			query.Append("'").Append(patientTreatmentGuid.ToString()).Append("',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[1] = query.ToString();
			query.Remove(0, query.Length);
			//
			Guid patientSpecimenGuid = Guid.NewGuid();
			query.Append("INSERT INTO dbo.PatientSPECIMEN (");
			query.Append(TABLES.PatientSpecimen.PatientSpecimenGuid).Append(",");
			query.Append(TABLES.PatientSpecimen.PatientGuid).Append(",");
			query.Append(TABLES.PatientSpecimen.SpecimenCollectionDate).Append(",");
			query.Append(TABLES.PatientSpecimen.SpecimenReceivedDate).Append(",");
			query.Append(TABLES.PatientSpecimen.SpecimenExpirationDate).Append(",");
			query.Append(TABLES.PatientSpecimen.SpecimenStatusCode).Append(",");
			query.Append(TABLES.PatientSpecimen.UnacceptableSpecimenIndicator).Append(",");
			query.Append(TABLES.PatientSpecimen.SpecimenUid).Append(",");
			query.Append(TABLES.PatientSpecimen.DivisionCode).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateFunctionId).Append(")");
			query.Append("VALUES (");
			query.Append("'").Append(patientSpecimenGuid.ToString()).Append("',");
			query.Append("'").Append(patientGuid.ToString()).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now.AddDays(3))).Append("',");
			query.Append("'A',");
			query.Append("'0',");
			query.Append("'").Append(DataCreator.GetNewSpecimenUid()).Append("',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[2] = query.ToString();
			query.Remove(0, query.Length);
			//
			Guid orderedTestGuid = Guid.NewGuid();
			query.Append("INSERT INTO ORDEREDTEST (");
			query.Append(TABLES.OrderedTest.OrderedTestGuid).Append(",");
			query.Append(TABLES.OrderedTest.PatientOrderGuid).Append(",");
			query.Append(TABLES.OrderedTest.PatientSpecimenGuid).Append(",");
			query.Append(TABLES.OrderedTest.OrderableTestId).Append(",");
			query.Append(TABLES.OrderedTest.OrderStatusCode).Append(",");
			query.Append(TABLES.OrderedTest.TaskStatusCode).Append(",");
			query.Append(TABLES.OrderedTest.OrderUrgencyCode).Append(",");		//new
			query.Append(TABLES.OrderedTest.DivisionCode).Append(",");
			query.Append(TABLES.OrderedTest.LastUpdateDate).Append(",");
			query.Append(TABLES.OrderedTest.LastUpdateUser).Append(",");
			query.Append(TABLES.OrderedTest.LastUpdateFunctionId + ")");
			query.Append("VALUES (");
			query.Append("'").Append(orderedTestGuid.ToString()).Append("',");
			query.Append("'").Append(patientOrderGuid.ToString()).Append("',");
			query.Append("'").Append(patientSpecimenGuid.ToString()).Append("',");
			query.Append("'").Append(Convert.ToInt32(Common.OrderableTest.ABID)).Append("',");
			query.Append((_skipInvalidate) ? "'P'," : "'C',");
			query.Append("'C',");
			query.Append("'R',");		//new
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[3] = query.ToString();
			query.Remove(0, query.Length);
			//
			Guid specimenTestGuid1 = Guid.NewGuid();
			query.Append("INSERT INTO SPECIMENTEST (");
			query.Append(TABLES.SpecimenTest.SpecimenTestGuid).Append(",");
			query.Append(TABLES.SpecimenTest.PatientSpecimenGuid).Append(",");
			query.Append(TABLES.SpecimenTest.OrderedTestGuid).Append(",");
			query.Append(TABLES.SpecimenTest.BloodTestTypeId).Append(",");
			query.Append(TABLES.SpecimenTest.TestDate).Append(",");
			query.Append(TABLES.SpecimenTest.AntibodyTypeId).Append(",");
			query.Append(TABLES.SpecimenTest.RecordStatusCode).Append(",");
			query.Append(TABLES.PatientSpecimen.DivisionCode).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientSpecimen.EntryTechId).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateFunctionId).Append(")");
			query.Append("VALUES (");
			query.Append("'").Append(specimenTestGuid1.ToString()).Append("',");
			query.Append("'").Append(patientSpecimenGuid.ToString()).Append("',");
			query.Append("'").Append(orderedTestGuid.ToString()).Append("',");
			query.Append("'96',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'24',");
			query.Append("'A',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[4] = query.ToString();
			query.Remove(0, query.Length);
			//
			Guid specimenTestGuid2 = Guid.NewGuid();
			query.Append("INSERT INTO SPECIMENTEST (");
			query.Append(TABLES.SpecimenTest.SpecimenTestGuid).Append(",");
			query.Append(TABLES.SpecimenTest.PatientSpecimenGuid).Append(",");
			query.Append(TABLES.SpecimenTest.OrderedTestGuid).Append(",");
			query.Append(TABLES.SpecimenTest.BloodTestTypeId).Append(",");
			query.Append(TABLES.SpecimenTest.TestDate).Append(",");
			query.Append(TABLES.SpecimenTest.AntibodyTypeId).Append(",");
			query.Append(TABLES.SpecimenTest.OffsiteCost).Append(",");
			query.Append(TABLES.SpecimenTest.OffsiteIndicator).Append(",");
			query.Append(TABLES.SpecimenTest.OffsiteLocation).Append(",");
			query.Append(TABLES.SpecimenTest.RecordStatusCode).Append(",");
			query.Append(TABLES.PatientSpecimen.DivisionCode).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientSpecimen.EntryTechId).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateFunctionId).Append(")");
			query.Append("VALUES (");
			query.Append("'").Append(specimenTestGuid2.ToString()).Append("',");
			query.Append("'").Append(patientSpecimenGuid.ToString()).Append("',");
			query.Append("'").Append(orderedTestGuid.ToString()).Append("',");
			query.Append("'96',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'29',");
			query.Append("120,");
			query.Append("1,");
			query.Append("'Unit Test 7041',");
			query.Append("'A',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[5] = query.ToString();
			query.Remove(0, query.Length);
			//
			Guid patientTransfusionRequirementGuid1 = Guid.NewGuid();
			query.Append("INSERT INTO dbo.PatientTRANSFUSIONREQUIREMENT (");
			query.Append(TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.PatientGuid).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.TransfusionRequirementText).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.AntibodyTypeId).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.CreateDate).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.CreateUser).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.CreateDivisionCode).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.RecordStatusCode).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.SpecimenTestGuid).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.LastUpdateFunctionId).Append(")");
			query.Append("VALUES (");
			query.Append("'").Append(patientTransfusionRequirementGuid1.ToString()).Append("',");
			query.Append("'").Append(patientGuid.ToString()).Append("',");
			query.Append("'").Append("Anti-Jk(a)").Append("',");
			query.Append("'").Append(Common.Utility.GetTransfusionCategoryCodeFromEnum(Common.TransfusionRequirementCategoryCode.AntibodyIdentified)).Append("',");
			query.Append("'24',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString()).Append("',");
			query.Append("'").Append(specimenTestGuid1.ToString()).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[6] = query.ToString();
			query.Remove(0, query.Length);
			//
			Guid patientTransfusionRequirementGuid2 = Guid.NewGuid();
			query.Append("INSERT INTO dbo.PatientTRANSFUSIONREQUIREMENT (");
			query.Append(TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.PatientGuid).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.TransfusionRequirementText).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.AntibodyTypeId).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.CreateDate).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.CreateUser).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.CreateDivisionCode).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.RecordStatusCode).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.SpecimenTestGuid).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientTransfusionRequirement.LastUpdateFunctionId).Append(")");
			query.Append("VALUES (");
			query.Append("'").Append(patientTransfusionRequirementGuid2.ToString()).Append("',");
			query.Append("'").Append(patientGuid.ToString()).Append("',");
			query.Append("'").Append("Anti-K").Append("',");
			query.Append("'").Append(Common.Utility.GetTransfusionCategoryCodeFromEnum(Common.TransfusionRequirementCategoryCode.AntibodyIdentified)).Append("',");
			query.Append("'29',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString()).Append("',");
			query.Append("'").Append(specimenTestGuid2.ToString()).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Environment.UserName).Append("',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[7] = query.ToString();
			query.Remove(0, query.Length);
			//

			for (int idx = 0; idx < queries.Length; idx++)
			{
				UnitTestUtil.RunSQL(queries[idx]);
			}

			if (_skipInvalidate) return;
			//
			BOL.OrderedTest tmpOT = new BOL.OrderedTest(orderedTestGuid,patientOrderGuid);
			System.Collections.ArrayList alST = BOL.OrderedTest.GetSpecimenTestResultsForOrderedTest(orderedTestGuid);

			System.Collections.ArrayList alWorkload = new System.Collections.ArrayList();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.AntibodyIdentificationWorkUp);
			alWorkload.Add(Common.WorkloadProcessID.AntibodyIdentificationWorkUp);
			//
			bool retValue = BOL.SpecimenTest.InvalidateSpecimenTestResults(alST, "UnitTest 7041", true, Common.UpdateFunction.UnitTests, alWorkload, patientGuid, patientRV);
			//
			Assert.IsTrue(retValue);
		}

		#region Helper Methods

		public static void BuildABORhFromSpecimenTests(Guid patientGuid, Guid patientTreatmentGuid, Guid patientSpecimenGuid, Guid patientOrderGuid, Guid orderedTestGuid, Guid specimenTestAboGuid, Guid specimenTestRhGuid, string aboInterp, string rhInterp)
		{
			string [] queries = new string [6];
			System.Text.StringBuilder query = new System.Text.StringBuilder();
			//
			query.Append("INSERT INTO dbo.PatientTREATMENT (");
			query.Append(TABLES.PatientTreatment.PatientTreatmentGuid).Append(",");
			query.Append(TABLES.PatientTreatment.PatientGuid).Append(",");
			query.Append(TABLES.PatientTreatment.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientTreatment.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientTreatment.LastUpdateFunctionId).Append(")");
			query.Append("VALUES(");
			query.Append("'").Append(patientTreatmentGuid.ToString()).Append("',");
			query.Append("'").Append(patientGuid.ToString()).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'" + Common.LogonUser.LogonUserName + "',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[0] = query.ToString();
			query.Remove(0, query.Length);
			//
			query.Append("INSERT INTO dbo.PatientORDER (");
			query.Append(TABLES.PatientOrder.PatientOrderGuid).Append(",");
			query.Append(TABLES.PatientOrder.PatientTreatmentGuid).Append(",");
			query.Append(TABLES.PatientOrder.DivisionCode).Append(",");
			query.Append(TABLES.PatientOrder.OrderingProviderId).Append(",");
			query.Append(TABLES.PatientOrder.OrderGroupNumber).Append(",");
			query.Append(TABLES.PatientOrder.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientOrder.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientOrder.LastUpdateFunctionId).Append(")");
			query.Append("VALUES(");
			query.Append("'").Append(patientOrderGuid.ToString()).Append("',");
			query.Append("'").Append(patientTreatmentGuid.ToString()).Append("',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(new Random().Next(11111,99999).ToString()).Append("',");
			query.Append("'").Append(new Random().Next(11111,99999).ToString()).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'" + Common.LogonUser.LogonUserName + "',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[1] = query.ToString();
			query.Remove(0, query.Length);
			//
			query.Append("INSERT INTO dbo.PatientSPECIMEN (");
			query.Append(TABLES.PatientSpecimen.PatientSpecimenGuid).Append(",");
			query.Append(TABLES.PatientSpecimen.PatientGuid).Append(",");
			query.Append(TABLES.PatientSpecimen.SpecimenCollectionDate).Append(",");
			query.Append(TABLES.PatientSpecimen.SpecimenReceivedDate).Append(",");
			query.Append(TABLES.PatientSpecimen.SpecimenExpirationDate).Append(",");
			query.Append(TABLES.PatientSpecimen.SpecimenStatusCode).Append(",");
			query.Append(TABLES.PatientSpecimen.UnacceptableSpecimenIndicator).Append(",");
			query.Append(TABLES.PatientSpecimen.SpecimenUid).Append(",");
			query.Append(TABLES.PatientSpecimen.DivisionCode).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateFunctionId).Append(")");
			query.Append("VALUES (");
			query.Append("'").Append(patientSpecimenGuid.ToString()).Append("',");
			query.Append("'").Append(patientGuid.ToString()).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now.AddDays(3))).Append("',");
			query.Append("'A',");
			query.Append("'0',");
			query.Append("'").Append(DateTime.Now.ToString("yyyyMMddHHmmss")).Append("',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'" + Common.LogonUser.LogonUserName + "',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[2] = query.ToString();
			query.Remove(0, query.Length);
			//
			query.Append("INSERT INTO ORDEREDTEST (");
			query.Append(TABLES.OrderedTest.OrderedTestGuid).Append(",");
			query.Append(TABLES.OrderedTest.PatientOrderGuid).Append(",");
			query.Append(TABLES.OrderedTest.PatientSpecimenGuid).Append(",");
			query.Append(TABLES.OrderedTest.OrderableTestId).Append(",");
			query.Append(TABLES.OrderedTest.OrderStatusCode).Append(",");
			query.Append(TABLES.OrderedTest.TaskStatusCode).Append(",");
			query.Append(TABLES.OrderedTest.DivisionCode).Append(",");
			query.Append(TABLES.OrderedTest.LastUpdateDate).Append(",");
			query.Append(TABLES.OrderedTest.LastUpdateUser).Append(",");
			query.Append(TABLES.OrderedTest.LastUpdateFunctionId + ")");
			query.Append("VALUES (");
			query.Append("'").Append(orderedTestGuid.ToString()).Append("',");
			query.Append("'").Append(patientOrderGuid.ToString()).Append("',");
			query.Append("'").Append(patientSpecimenGuid.ToString()).Append("',");
			query.Append("'").Append(Convert.ToInt32(Common.OrderableTest.ABORh)).Append("',");
			query.Append("'C',");
			query.Append("'C',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'" + Common.LogonUser.LogonUserName + "',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[3] = query.ToString();
			query.Remove(0, query.Length);
			//
			query.Append("INSERT INTO SPECIMENTEST (");
			query.Append(TABLES.SpecimenTest.SpecimenTestGuid).Append(",");
			query.Append(TABLES.SpecimenTest.PatientSpecimenGuid).Append(",");
			query.Append(TABLES.SpecimenTest.OrderedTestGuid).Append(",");
			query.Append(TABLES.SpecimenTest.BloodTestTypeId).Append(",");
			query.Append(TABLES.SpecimenTest.TestDate).Append(",");
			query.Append(TABLES.SpecimenTest.TestResultId).Append(",");
			query.Append(TABLES.SpecimenTest.AboRhChangeIndicator).Append(",");
			query.Append(TABLES.SpecimenTest.RecordStatusCode).Append(",");
			query.Append(TABLES.SpecimenTest.EntryTechId).Append(",");
			query.Append(TABLES.PatientSpecimen.DivisionCode).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateFunctionId).Append(")");
			query.Append("VALUES (");
			query.Append("'").Append(specimenTestAboGuid.ToString()).Append("',");
			query.Append("'").Append(patientSpecimenGuid.ToString()).Append("',");
			query.Append("'").Append(orderedTestGuid.ToString()).Append("',");
			query.Append("'18',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(aboInterp).Append("',");
			query.Append("1,");
			query.Append("'A',");
			query.Append("'" + Common.LogonUser.LogonUserName + "',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'" + Common.LogonUser.LogonUserName + "',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[4] = query.ToString();
			query.Remove(0, query.Length);
			//
			query.Append("INSERT INTO SPECIMENTEST (");
			query.Append(TABLES.SpecimenTest.SpecimenTestGuid).Append(",");
			query.Append(TABLES.SpecimenTest.PatientSpecimenGuid).Append(",");
			query.Append(TABLES.SpecimenTest.OrderedTestGuid).Append(",");
			query.Append(TABLES.SpecimenTest.BloodTestTypeId).Append(",");
			query.Append(TABLES.SpecimenTest.TestDate).Append(",");
			query.Append(TABLES.SpecimenTest.TestResultId).Append(",");
			query.Append(TABLES.SpecimenTest.AboRhChangeIndicator).Append(",");
			query.Append(TABLES.SpecimenTest.RecordStatusCode).Append(",");
			query.Append(TABLES.SpecimenTest.EntryTechId).Append(",");
			query.Append(TABLES.PatientSpecimen.DivisionCode).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateDate).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateUser).Append(",");
			query.Append(TABLES.PatientSpecimen.LastUpdateFunctionId).Append(")");
			query.Append("VALUES (");
			query.Append("'").Append(specimenTestRhGuid.ToString()).Append("',");
			query.Append("'").Append(patientSpecimenGuid.ToString()).Append("',");
			query.Append("'").Append(orderedTestGuid.ToString()).Append("',");
			query.Append("'21',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'").Append(rhInterp).Append("',");
			query.Append("1,");
			query.Append("'A',");
			query.Append("'" + Common.LogonUser.LogonUserName + "',");
			query.Append("'").Append(Common.LogonUser.LogonUserDivisionCode).Append("',");
			query.Append("'").Append(Common.VBECSDateTime.FormatDateTimeString(DateTime.Now)).Append("',");
			query.Append("'" + Common.LogonUser.LogonUserName + "',");
			query.Append("'").Append(Convert.ToInt32(Common.UpdateFunction.UnitTests)).Append("')");
			//
			queries[5] = query.ToString();
			query.Remove(0, query.Length);
			//
			for (int idx = 0; idx < queries.Length; idx++)
			{
				UnitTestUtil.RunSQL(queries[idx]);
			}
		}

		#endregion

	}
}
#endif
